import { world } from '@minecraft/server';
export function sortByPlacementPriority(branchEntities) {
    return branchEntities.sort((a, b)=>{
        const aData = JSON.parse(a.getDynamicProperty("jigsawData"));
        const bData = JSON.parse(b.getDynamicProperty("jigsawData"));
        return bData.placementPriority - aData.placementPriority;
    });
}
export function sortBySelectionPriority(dataArray) {
    return dataArray.sort((a, b)=>{
        return b.selectionPriority - a.selectionPriority;
    });
}
export function selectionPriorityExact(dataArray) {
    const firstPriority = dataArray[0].selectionPriority;
    return dataArray.every((item)=>item.selectionPriority === firstPriority);
}
export function parseSize(name) {
    const elements = name.split('_');
    return {
        x: parseInt(elements[elements.length - 3]),
        y: parseInt(elements[elements.length - 2]),
        z: parseInt(elements[elements.length - 1])
    };
}
export function getPlacedBounds() {
    let placedBoundsLength = 0;
    while(true){
        if (world.getDynamicProperty(`jigsaw:placed_bounds_${placedBoundsLength}`) == undefined) break;
        placedBoundsLength++;
    }
    let allBounds = [];
    for(let i = 0; i < placedBoundsLength; i++){
        allBounds = allBounds.concat(JSON.parse(world.getDynamicProperty(`jigsaw:placed_bounds_${i}`)));
    }
    return allBounds;
}
export function addPlacedBounds(bounds) {
    const placedBounds = getPlacedBounds();
    placedBounds.push(bounds);
    let placedBoundsLength = 0;
    while(true){
        if (world.getDynamicProperty(`jigsaw:placed_bounds_${placedBoundsLength + 1}`) == undefined) break;
        placedBoundsLength++;
    }
    try {
        world.setDynamicProperty(`jigsaw:placed_bounds_${placedBoundsLength}`, JSON.stringify(placedBounds));
    } catch  {
        const newPlacedBounds = [];
        newPlacedBounds.push(bounds);
        world.setDynamicProperty(`jigsaw:placed_bounds_${placedBoundsLength + 1}`, JSON.stringify(newPlacedBounds, null, 4));
    }
}
